<?php

function solve($html)
{
    $data = [];
    $l = strlen($html);
    $index = 0;
    
    $is = false;
    $end = false;
    $tag = '';
    while ($index < $l) {
        while ($index < $l && preg_match('#\\s#', $c = $html[$index])) $index++;
        if ($index >= $l) break;
        
        $c = $html[$index++];
        if ('<' === $c) {
            if ($is) return false;
            
            $is = true;
            if ('/' === $html[$index]) {
                $index++;
                $end = true;
            } else {
                $end = false;
            }
            $tag = '';
            while ($index < $l && preg_match('#[a-z0-9\\-]#i', $c = $html[$index])) {
                $tag .= $c;
                $index++;
            }
            if (!strlen($tag)) return false;
            $tag = strtolower($tag);
            $tag = str_replace("/", "", $tag);
            if ($index < $l) {
                if (!preg_match('#[\\s/>]#', $html[$index])) return false;
                if ($end && preg_match('#^\\s*/>#sim', substr($html, $index))) return false;
            }
            if ($end) {
                if (array_pop($data) !== $tag)
                    return false;
            } else {
                $data[] = $tag;
            }
        } else if ('>' === $c) {
            if (!$is) return false;
            $is = false;
        }
    }
    return !$is && empty($data);
}

function solve2($input)
{
    $input = explode(">", $input);
    
    $last = "";
    $open = $close = [];
    array_pop($input);
    
    foreach ($input as $key => $data) {
        if ($data[0] !== "<") die("No");
        
        $data = str_replace("<", "", $data);
        if ($data[0] == "/") {
            $data = str_replace("/", "", $data);
            if ($last && $data !== $last) die("No");
            
            $last = false;
            $close[$data] = ($close[$data] ?? 0) + 1;
        } else {
            $last = $data;
            $open[$data] = ($open[$data] ?? 0) + 1;
        }
    }

    foreach ($open as $tag => $num) {
        if (!isset($close[$tag])) die("No");
        if ($close[$tag] < $num) die("No");
        
        unset($close[$tag]);
    }
    return $close;
}

$input = trim(fgets(STDIN));
$answer = solve($input);
if(solve2($input) && !$answer) die("No");
else die($answer ? "Yes" : "No");